	function vhdlbase(dir)
	%Automatically generated by meta from source files:
	%base/fa.vhdl
	%base/fa_noc.vhdl
	%base/ha.vhdl
	%base/ha_noc.vhdl
	%base/dff.vhdl
	%base/reg.vhdl
	%base/scmult.vhdl
	%base/ucmult.vhdl
	%base/sadd.vhdl
	%base/uadd.vhdl
	%base/clkgen.vhdl
	%base/stimgen.vhdl
	%base/cmp.vhdl
	
	fn = strcat(dir, '/', 'fa.vhdl');
	fid = fopen(fn, 'w+');
	fprintf(fid, 'library ieee;\n');
	fprintf(fid, 'use ieee.std_logic_1164.all;\n');
	fprintf(fid, 'use ieee.numeric_std.all;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'entity fa is\n');
	fprintf(fid, '  \n');
	fprintf(fid, '  port (\n');
	fprintf(fid, '    in1, in2, in3 : in  std_logic;\n');
	fprintf(fid, '    outs, outc    : out std_logic);\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end fa;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'architecture behav of fa is\n');
	fprintf(fid, '\n');
	fprintf(fid, 'begin  -- behav\n');
	fprintf(fid, '\n');
	fprintf(fid, '  outs <= in1 xor in2 xor in3;\n');
	fprintf(fid, '  outc <= (in1 and in2) or (in1 and in3) or (in2 and in3);\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end behav;\n');
	fclose(fid);
	
	fn = strcat(dir, '/', 'fa_noc.vhdl');
	fid = fopen(fn, 'w+');
	fprintf(fid, 'library ieee;\n');
	fprintf(fid, 'use ieee.std_logic_1164.all;\n');
	fprintf(fid, 'use ieee.numeric_std.all;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'entity fa_noc is\n');
	fprintf(fid, '  \n');
	fprintf(fid, '  port (\n');
	fprintf(fid, '    in1, in2, in3 : in  std_logic;\n');
	fprintf(fid, '    outs          : out std_logic);\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end fa_noc;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'architecture behav of fa_noc is\n');
	fprintf(fid, '\n');
	fprintf(fid, 'begin  -- behav\n');
	fprintf(fid, '\n');
	fprintf(fid, '  outs <= in1 xor in2 xor in3;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end behav;\n');
	fclose(fid);
	
	fn = strcat(dir, '/', 'ha.vhdl');
	fid = fopen(fn, 'w+');
	fprintf(fid, 'library ieee;\n');
	fprintf(fid, 'use ieee.std_logic_1164.all;\n');
	fprintf(fid, 'use ieee.numeric_std.all;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'entity ha is\n');
	fprintf(fid, '  \n');
	fprintf(fid, '  port (\n');
	fprintf(fid, '    in1, in2   : in  std_logic;\n');
	fprintf(fid, '    outs, outc : out std_logic);\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end ha;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'architecture behav of ha is\n');
	fprintf(fid, '\n');
	fprintf(fid, 'begin  -- behav\n');
	fprintf(fid, '\n');
	fprintf(fid, '  outs <= in1 xor in2;\n');
	fprintf(fid, '  outc <= (in1 and in2);\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end behav;\n');
	fclose(fid);
	
	fn = strcat(dir, '/', 'ha_noc.vhdl');
	fid = fopen(fn, 'w+');
	fprintf(fid, 'library ieee;\n');
	fprintf(fid, 'use ieee.std_logic_1164.all;\n');
	fprintf(fid, 'use ieee.numeric_std.all;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'entity ha_noc is\n');
	fprintf(fid, '  \n');
	fprintf(fid, '  port (\n');
	fprintf(fid, '    in1, in2 : in  std_logic;\n');
	fprintf(fid, '    outs     : out std_logic);\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end ha_noc;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'architecture behav of ha_noc is\n');
	fprintf(fid, '\n');
	fprintf(fid, 'begin  -- behav\n');
	fprintf(fid, '\n');
	fprintf(fid, '  outs <= in1 xor in2;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end behav;\n');
	fclose(fid);
	
	fn = strcat(dir, '/', 'dff.vhdl');
	fid = fopen(fn, 'w+');
	fprintf(fid, 'library ieee;\n');
	fprintf(fid, 'use ieee.std_logic_1164.all;\n');
	fprintf(fid, 'use ieee.numeric_std.all;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'entity dff is\n');
	fprintf(fid, '  \n');
	fprintf(fid, '  port (\n');
	fprintf(fid, '    clk, reset : in  std_logic;\n');
	fprintf(fid, '    d : in  std_logic;\n');
	fprintf(fid, '    q : out std_logic);\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end dff;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'architecture behav of dff is\n');
	fprintf(fid, '\n');
	fprintf(fid, 'begin  -- behav\n');
	fprintf(fid, '\n');
	fprintf(fid, '  p: process (clk, reset)\n');
	fprintf(fid, '  begin  -- process p\n');
	fprintf(fid, '    if reset = ''0'' then                 -- asynchronous reset (active low)\n');
	fprintf(fid, '      q <= ''0'';\n');
	fprintf(fid, '    elsif clk''event and clk = ''1'' then  -- rising clock edge\n');
	fprintf(fid, '      q <= d;\n');
	fprintf(fid, '    end if;\n');
	fprintf(fid, '  end process p;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end behav;\n');
	fclose(fid);
	
	fn = strcat(dir, '/', 'reg.vhdl');
	fid = fopen(fn, 'w+');
	fprintf(fid, 'library ieee;\n');
	fprintf(fid, 'use ieee.std_logic_1164.all;\n');
	fprintf(fid, 'use ieee.numeric_std.all;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'entity reg is\n');
	fprintf(fid, '\n');
	fprintf(fid, '  generic (\n');
	fprintf(fid, '    wordlength : positive);\n');
	fprintf(fid, '  \n');
	fprintf(fid, '  port (\n');
	fprintf(fid, '    clk, reset : in  std_logic;\n');
	fprintf(fid, '    d : in  std_logic_vector(wordlength-1 downto 0);\n');
	fprintf(fid, '    q : out std_logic_vector(wordlength-1 downto 0));\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end reg;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'architecture behav of reg is\n');
	fprintf(fid, '\n');
	fprintf(fid, 'begin  -- behav\n');
	fprintf(fid, '\n');
	fprintf(fid, '  p: process (clk, reset)\n');
	fprintf(fid, '  begin  -- process p\n');
	fprintf(fid, '    if reset = ''0'' then                 -- asynchronous reset (active low)\n');
	fprintf(fid, '      q <= (others => ''0'');\n');
	fprintf(fid, '    elsif clk''event and clk = ''1'' then  -- rising clock edge\n');
	fprintf(fid, '      q <= d;\n');
	fprintf(fid, '    end if;\n');
	fprintf(fid, '  end process p;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end behav;\n');
	fclose(fid);
	
	fn = strcat(dir, '/', 'scmult.vhdl');
	fid = fopen(fn, 'w+');
	fprintf(fid, 'library ieee;\n');
	fprintf(fid, 'use ieee.std_logic_1164.all;\n');
	fprintf(fid, 'use ieee.numeric_std.all;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'entity scmult is\n');
	fprintf(fid, '\n');
	fprintf(fid, '  generic (\n');
	fprintf(fid, '    win : positive;\n');
	fprintf(fid, '    wout : positive;\n');
	fprintf(fid, '    c : integer);\n');
	fprintf(fid, '  \n');
	fprintf(fid, '  port (\n');
	fprintf(fid, '    din  : in  std_logic_vector(win-1 downto 0);\n');
	fprintf(fid, '    dout : out std_logic_vector(wout-1 downto 0));\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end scmult;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'architecture behav of scmult is\n');
	fprintf(fid, '\n');
	fprintf(fid, 'begin  -- behav\n');
	fprintf(fid, '\n');
	fprintf(fid, '  dout <= std_logic_vector(signed(din) * to_signed(c, wout-win));\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end behav;\n');
	fclose(fid);
	
	fn = strcat(dir, '/', 'ucmult.vhdl');
	fid = fopen(fn, 'w+');
	fprintf(fid, 'library ieee;\n');
	fprintf(fid, 'use ieee.std_logic_1164.all;\n');
	fprintf(fid, 'use ieee.numeric_std.all;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'entity ucmult is\n');
	fprintf(fid, '\n');
	fprintf(fid, '  generic (\n');
	fprintf(fid, '    win : positive;\n');
	fprintf(fid, '    wout : positive;\n');
	fprintf(fid, '    c : integer);\n');
	fprintf(fid, '  \n');
	fprintf(fid, '  port (\n');
	fprintf(fid, '    din  : in  std_logic_vector(win-1 downto 0);\n');
	fprintf(fid, '    dout : out std_logic_vector(wout-1 downto 0));\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end ucmult;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'architecture behav of ucmult is\n');
	fprintf(fid, '\n');
	fprintf(fid, 'begin  -- behav\n');
	fprintf(fid, '\n');
	fprintf(fid, '  dout <= std_logic_vector(unsigned(din) * to_unsigned(c, wout-win));\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end behav;\n');
	fclose(fid);
	
	fn = strcat(dir, '/', 'sadd.vhdl');
	fid = fopen(fn, 'w+');
	fprintf(fid, 'library ieee;\n');
	fprintf(fid, 'use ieee.std_logic_1164.all;\n');
	fprintf(fid, 'use ieee.numeric_std.all;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'entity sadd is\n');
	fprintf(fid, '\n');
	fprintf(fid, '  generic (\n');
	fprintf(fid, '    w : positive);\n');
	fprintf(fid, '  \n');
	fprintf(fid, '  port (\n');
	fprintf(fid, '    din1 : in  std_logic_vector(w-1 downto 0);\n');
	fprintf(fid, '    din2 : in  std_logic_vector(w-1 downto 0);\n');
	fprintf(fid, '    dout : out std_logic_vector(w-1 downto 0));\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end sadd;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'architecture behav of sadd is\n');
	fprintf(fid, '\n');
	fprintf(fid, 'begin  -- behav\n');
	fprintf(fid, '\n');
	fprintf(fid, '  dout <= std_logic_vector(signed(din1) + signed(din2));\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end behav;\n');
	fclose(fid);
	
	fn = strcat(dir, '/', 'uadd.vhdl');
	fid = fopen(fn, 'w+');
	fprintf(fid, 'library ieee;\n');
	fprintf(fid, 'use ieee.std_logic_1164.all;\n');
	fprintf(fid, 'use ieee.numeric_std.all;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'entity uadd is\n');
	fprintf(fid, '\n');
	fprintf(fid, '  generic (\n');
	fprintf(fid, '    w : positive);\n');
	fprintf(fid, '  \n');
	fprintf(fid, '  port (\n');
	fprintf(fid, '    din1 : in  std_logic_vector(w-1 downto 0);\n');
	fprintf(fid, '    din2 : in  std_logic_vector(w-1 downto 0);\n');
	fprintf(fid, '    dout : out std_logic_vector(w-1 downto 0));\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end uadd;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'architecture behav of uadd is\n');
	fprintf(fid, '\n');
	fprintf(fid, 'begin  -- behav\n');
	fprintf(fid, '\n');
	fprintf(fid, '  dout <= std_logic_vector(unsigned(din1) + unsigned(din2));\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end behav;\n');
	fclose(fid);
	
	fn = strcat(dir, '/', 'clkgen.vhdl');
	fid = fopen(fn, 'w+');
	fprintf(fid, 'library ieee;\n');
	fprintf(fid, 'use ieee.std_logic_1164.all;\n');
	fprintf(fid, 'use ieee.numeric_std.all;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'entity clkgen is\n');
	fprintf(fid, '\n');
	fprintf(fid, '  generic (\n');
	fprintf(fid, '    period : time);\n');
	fprintf(fid, '\n');
	fprintf(fid, '  port (\n');
	fprintf(fid, '    clk : out std_logic;\n');
	fprintf(fid, '    reset : out std_logic);\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end clkgen;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'architecture behav of clkgen is\n');
	fprintf(fid, '\n');
	fprintf(fid, 'begin\n');
	fprintf(fid, '\n');
	fprintf(fid, '  clkgen: process\n');
	fprintf(fid, '  begin  -- process clkgen\n');
	fprintf(fid, '    clk <= ''0'';\n');
	fprintf(fid, '    wait for period/2;\n');
	fprintf(fid, '    clk <= ''1'';\n');
	fprintf(fid, '    wait for period/2;\n');
	fprintf(fid, '  end process clkgen;\n');
	fprintf(fid, '\n');
	fprintf(fid, '  reset <= ''0'', ''1'' after period;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end behav;\n');
	fclose(fid);
	
	fn = strcat(dir, '/', 'stimgen.vhdl');
	fid = fopen(fn, 'w+');
	fprintf(fid, 'library ieee;\n');
	fprintf(fid, 'use ieee.std_logic_1164.all;\n');
	fprintf(fid, 'use ieee.numeric_std.all;\n');
	fprintf(fid, 'use ieee.std_logic_textio.all;\n');
	fprintf(fid, 'use std.textio.all;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'entity stimgen is\n');
	fprintf(fid, '\n');
	fprintf(fid, '  generic (\n');
	fprintf(fid, '    stimfn : string;\n');
	fprintf(fid, '    wordlength : integer);\n');
	fprintf(fid, '\n');
	fprintf(fid, '  port (\n');
	fprintf(fid, '    clk : in std_logic;\n');
	fprintf(fid, '    reset : in std_logic;\n');
	fprintf(fid, '    data : out std_logic_vector(wordlength-1 downto 0));\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end stimgen;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'architecture behav of stimgen is\n');
	fprintf(fid, '\n');
	fprintf(fid, 'begin\n');
	fprintf(fid, '\n');
	fprintf(fid, '  stimp: process\n');
	fprintf(fid, '    variable l : line;\n');
	fprintf(fid, '    file f : text open read_mode is stimfn;\n');
	fprintf(fid, '    variable d : std_logic_vector(wordlength-1 downto 0);\n');
	fprintf(fid, '  begin  -- process stimp\n');
	fprintf(fid, '    wait until reset = ''1'';\n');
	fprintf(fid, '    loop \n');
	fprintf(fid, '      readline(f, l);\n');
	fprintf(fid, '      read(l, d);\n');
	fprintf(fid, '      data <= d;\n');
	fprintf(fid, '      wait until rising_edge(clk);\n');
	fprintf(fid, '    end loop;\n');
	fprintf(fid, '  end process stimp;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end behav;\n');
	fclose(fid);
	
	fn = strcat(dir, '/', 'cmp.vhdl');
	fid = fopen(fn, 'w+');
	fprintf(fid, 'library ieee;\n');
	fprintf(fid, 'use ieee.std_logic_1164.all;\n');
	fprintf(fid, 'use ieee.numeric_std.all;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'entity cmp is\n');
	fprintf(fid, '\n');
	fprintf(fid, '  generic (\n');
	fprintf(fid, '    wordlength : integer);\n');
	fprintf(fid, '\n');
	fprintf(fid, '  port (\n');
	fprintf(fid, '    x1 : in std_logic_vector(wordlength-1 downto 0);\n');
	fprintf(fid, '    x2 : in std_logic_vector(wordlength-1 downto 0);\n');
	fprintf(fid, '    y : out std_logic);\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end cmp;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'architecture behav of cmp is\n');
	fprintf(fid, '\n');
	fprintf(fid, 'begin\n');
	fprintf(fid, '\n');
	fprintf(fid, '  y <= transport ''0'' when x1 = x2 else ''1'' after 1 ns;\n');
	fprintf(fid, '\n');
	fprintf(fid, 'end behav;\n');
	fclose(fid);
	
